<?php

class HeaderSaver {
    public $headers = array();
    public $code = null;   

    public function header($curl, $data){
        if (is_null($this->code) &&
            preg_match('@^HTTP/\d\.\d (\d+) @',$data,$matches)) {
            $this->code = $matches[1];
        } else {
            // Usunicie kocowych znakw nowego wiersza
            $trimmed = rtrim($data);
            if (strlen($trimmed)) {
                // Jeeli wiersz rozpoczyna si od znaku spacji lub tabulatora 
                // jest kontynuacj poprzedniego nagwka
                if (($trimmed[0] == ' ') || ($trimmed[0] == "\t")) {
                    // Przeksztacenie wiodcych znakw spacji w jeden znak spacji
                    $trimmed = preg_replace('@^[ \t]+@',' ', $trimmed);
                    $this->headers[count($this->headers)-1] .= $trimmed;
                } 
                // W przeciwnym przypadku jest nowym nagwkiem
                else {
                    $this->headers[] = $trimmed;
                }
            }
        }
        return strlen($data);
    }
    
}

$h = new HeaderSaver();
$c = curl_init('http://www.przyklad.com/plankton.php');
// Zarejestrowanie funkcji nagwkowej
curl_setopt($c, CURLOPT_HEADERFUNCTION, array($h,'header'));
curl_setopt($c, CURLOPT_RETURNTRANSFER, true);
$page = curl_exec($c);
// Zmienna $h przechowuje odpowiednie dane
print 'Kod odpowiedzi: ' . $h->code . "\n";
print "Nagwki odpowiedzi: \n";
foreach ($h->headers as $header) {
    print "  $header\n";
}
